/* NO USER CONFIGURABLE PARAMETERS HERE! */

/* Path Integral Monte Carlo code developed by A. Balaz 
   (antun@ipb.ac.rs) for papers:
         
   "Systematic Speedup in the Convergence of Path Integrals"
   by A. Bogojevic, A. Balaz, and A. Belic
   Phys. Rev. Lett. 94 (2005) 180403

   "Fast Converging Path Integrals for Time-Dependent Potentials"
   by A. Balaz, I. Vidanovic, A. Bogojevic, A, Pelster
   arXiv:0912.2743

   Address: Institute of Physics, Belgrade, Serbia
   Scientific Computing Laboratory, http://www.scl.rs/speedup/

   Public use and modification of this code is allowed providing
   the above paper is properly acknowledged. The author would be
   grateful for all information and/or comments regarding the use
   of the code.
*/

/* This is the header for file p.c. */

#include <math.h>

/* Initial and final time, and time of propagation, defined in main(), used in func(). */
extern double ta, tb, T;

/* Parameters of the potential, defined in main(), used in V0(). */
extern double *par;

/* Array with powers of 2 (two[n] = 2^n), defined in main(), used in func(). */
extern int *two;

/* Array of path integral norms, defined in main(), used in func(). */
extern double *norm;

/* Array of the exponents of Gaussian probability distribution functions,
   defined in distr(), used in func(). */
extern double *distrexp;

/* Variables used in function Vp(), for optimization purposes (powers of delta,
   eps = T / N, and other parameters of the potential). They are initialized
   in main() to zero.
*/

extern double *deltas, *epss, epsinv;
extern double *ftinv, *ts, *xs;

/* Variables used in the function func(). The variable qbar is the mid-point for a pair of points
   from the chosen path, variable action is the action for the given trajectory.
*/
double qbar, action;

/* Variables used in function func(). Variable Nmax = 2^s is the maximal number of time steps.
   Variable step is equal to 2^(s - n). In the bisection algorithm with Nmax = 2^s, paths are
   given by the arrays (q[0], ..., q[N]). If the current number of time steps is Nc = 2^n, the
   relevant paths are (q[0], q[step], ..., q[2^n step = Nmax]). 
*/
int Nmax, Nc, step;
