/* NO USER CONFIGURABLE PARAMETERS HERE! */

/* Path Integral Monte Carlo code developed by A. Balaz 
   (antun@ipb.ac.rs) for papers:
         
   "Systematic Speedup in the Convergence of Path Integrals"
   by A. Bogojevic, A. Balaz, and A. Belic
   Phys. Rev. Lett. 94 (2005) 180403

   "Fast Converging Path Integrals for Time-Dependent Potentials"
   by A. Balaz, I. Vidanovic, A. Bogojevic, A, Pelster
   arXiv:0912.2743

   Address: Institute of Physics, Belgrade, Serbia
   Scientific Computing Laboratory, http://www.scl.rs/speedup/

   Public use and modification of this code is allowed providing 
   the above paper is properly acknowledged. The author would be 
   grateful for all information and/or comments regarding the use   
   of the code.  
*/

/* This is the header for the main.c file.*/

/* Necessary headers that should be included. */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <sys/time.h>
#include <sprng.h>

/* Declarations of Numerical Recipes' functions used. */
int *ivector(long, long);
double *dvector(long, long);
double **dmatrix(long, long, long, long);
double ***d3tensor(long, long, long, long, long, long);
void free_ivector(int *, long, long);
void free_dvector(double *, long, long);
void free_dmatrix(double **, long, long, long, long);
void free_d3tensor(double ***, long, long, long, long, long, long);
void nrerror(char *);

/* Maximal needed power for potential parameteres. */
#define MAXDER 100

/* Declarations of functions used in main.c. */
double func(double *, int, int); /* Calculates the function that is averaged. */
void distr(double *, int); /* Generates the paths. */
void mc(double, double *, double *, double *, int); /* Implements the Monte Carlo method. */

/* Variables needed for using the SPRNG random number generator. */
int streamnum, nstreams, *stream;

/* Initial and final time, and time of propagation, defined in main(). */
double ta, tb, T;

/* Parameters of the potential, defined in main(), used in V0(). */
double *par;

/* Array with powers of 2 (two[n] = 2^n), defined in main(), used in func(). */
int *two;

/* Array of path integral norms, defined in main(), used in func(). */
double *norm;

/* Array of the exponents of Gaussian probability distribution functions,
   defined in distr(), used in func(). */
double *distrexp;

/* Array of 2 sigma^2 and 1 / (2 sigma^2) values, where sigma^2 = eps = T / 2^n. */
double *dsigma2, *dsigma2inv;

/* dpi = 2 pi */
double dpi;

/* Variables used in function Vp(), for optimization purposes (powers of delta,
   eps = T / N, and other parameters of the potential). They are initialized
   in main() to zero.
*/
double *deltas, *epss, epsinv;
double *ftinv, *ts, *xs;
